% Smoothing factor
p=0.95;

% Time span of interest
t=[0:0.05:10];

% Noise strength
sigma=0.1;

% Input noisy signal
sig=sin(t)+sigma*randn(1,length(t));

% Perform fft to break down components
F = fft2(sig);

% Get matrix as one big column, sorted in reverse order
F1 = F(:);
F1 = sort(abs(F1));

% Get max index of element to use for thresholding
j = ceil(p * length(F1));

% Get the value of the max element to allow
max_val = F1(j);

% Threshold the values
F = F .* (abs(F) > max_val);

% Reconstruct
new = ifft2(F);

plot(t,sig, t,new);
xlabel('Time (sec)')
ylabel('Sinusoidal Signal')
legend('original','smoothed')